//========================================================================
//  JRA-VAN Data Lab. TvvOP(Unit2)
//
//
//   쐬: JRA-VAN \tgEFAH[  2003N422
//
//========================================================================
//   (C) Copyright Turf Media System Co.,Ltd. 2003 All rights reserved
//========================================================================
unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, OleCtrls, JVDTLabLib_TLB ;

type
    TfrmJVLinkDialog = class(TForm)
    ButtonCancel: TButton;
    ProgressBar1: TProgressBar;
    ProgressBar2: TProgressBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    txtDataSpec: TEdit;
    txtFromDate: TEdit;
    ButtonStart: TButton;
    GroupBox1: TGroupBox;
    rbtNormal: TRadioButton;
    rbtIsthisweek: TRadioButton;
    rbtSetup: TRadioButton;
    TimerJVStatus: TTimer;

    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonStartClick(Sender: TObject);
    procedure TimerJVStatusTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);

  private
    { Private 錾 }
    procedure JVClosing();
    procedure JVReading();
  public
    { Public 錾 }

  end;

var
    frmJVLinkDialog: TfrmJVLinkDialog;
    DialogCancel : Boolean;             //LZtO
    ReadCount : Integer;                //JVOpen:Ǎ݃t@C
    DownloadCount : Integer;            //JVOpen:_E[ht@C
    LastFileTimeStamp : WideString;     //JVOpen:ŌɃ_E[ht@C̃^CX^v

implementation

uses Unit1;

{$R *.dfm}

//------------------------------------------------------------------------------
//      
//------------------------------------------------------------------------------
procedure TfrmJVLinkDialog.FormShow(Sender: TObject);
begin
    // EBhEɍŏʂɕ\
    SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0,
    SWP_NOMOVE or SWP_NOSIZE or SWP_NOACTIVATE);
end;

//------------------------------------------------------------------------------
//      f[^擾s{^NbN̏
//------------------------------------------------------------------------------
procedure TfrmJVLinkDialog.ButtonStartClick(Sender: TObject);
var
    DataSpec : WideString;
    FromDate : WideString;
    DataOption : Integer;
    ReturnCode  : Integer;              //JVLinkԒl
begin
    TimerJVStatus.Enabled:=false;       //^C}[~
    DialogCancel:=false;                //LZtO
    ProgressBar1.Position:=0;           //vOXo[
    ProgressBar2.Position:=0;
    //ݒ

    DataSpec := txtDataSpec.Text;       // t@Cʎq
    FromDate := txtFromDate.text;       // f[^񋟓tFROM

    if rbtNormal.Checked=true then
        DataOption:=1
    else if rbtIsthisweek.Checked=true then
        DataOption:=2
    else if rbtSetup.Checked=true then
        DataOption:=3;

    Cursor:=crAppStart;

    //**********************
    //JVLink_E[h
    //**********************
    ReturnCode := frmMain.JVLink1.JVOpen(DataSpec,
                                         FromDate,
                                         DataOption,
                                         ReadCount,
                                         DownloadCount,
                                         LastFileTimeStamp);

        //G[
    If ReturnCode <> 0 Then begin       //G[
        frmMain.PrintOut('JVOpenG[:' + IntToStr(ReturnCode) + #13#10 );
        //I
        JVClosing;
        end
    Else begin                          //
        frmMain.PrintOut('JVOpenI:' + IntToStr(ReturnCode) + #13#10 );
        frmMain.PrintOut('ReadCount:' +
                           IntToStr(ReadCount) +
                           ', DownloadCount:' +
                           IntToStr(DownloadCount) +
                           #13#10 );
        //_E[h`FbN
        If DownloadCount=0 then begin         //_E[hO
            //vOXo[POO\
            ProgressBar1.max:=100;                       //MAXPOOɐݒ
            ProgressBar1.Position:=ProgressBar1.Max;     //vOXo[POO\
            //Ǎݏ
            JVReading();
            //I
            JVClosing();
            end
        else begin                           //_E[hOȏ
            //ݒ
            Caption:='_E[hEEE';
            ProgressBar1.Max:=DownloadCount;            //vOXo[MAXlݒ
            TimerJVStatus.Enabled := true;              //^C}[N
        end;
    end;

    //I
    Exit;
end;

//------------------------------------------------------------------------------
//      ^C}[F_E[hivOXo[\
//------------------------------------------------------------------------------
procedure TfrmJVLinkDialog.TimerJVStatusTimer(Sender: TObject);
var
    ReturnCode  : Integer;              //JVLinkԒl
begin
    //**********************
    //JVLink_E[hi
    //**********************
        ReturnCode :=  frmMain.JVLink1.JVStatus;

    //G[
    If ReturnCode < 0 Then begin
        frmMain.PrintOut('JVStatusG[:' + IntToStr(ReturnCode) + #13#10 );
        //^C}[~
        TimerJVStatus.Enabled:=false;
        //I
        JVClosing;
        //I
        Exit;
        end
    Else If ReturnCode<DownloadCount then begin
        //vOXo[\
        Caption :='_E[hDDD('+ IntToStr(ReturnCode) + '/' + IntToStr(DownloadCount) + ')';
        ProgressBar1.Position:=ReturnCode;
        end
    Else If ReturnCode=DownloadCount then begin
        //^C}[~
        TimerJVStatus.Enabled:=false;
        //vOXo[\
        Caption :='_E[hDDD('+ IntToStr(ReturnCode) + '/' + IntToStr(DownloadCount) + ')';
        ProgressBar1.Position:= ReturnCode;
        //Ǎݏ
        JVReading;
        //I
        JVClosing;
        //I
        Exit;
    end;
end;


//------------------------------------------------------------------------------
//      Ǎݏ
//------------------------------------------------------------------------------
procedure TfrmJVLinkDialog.JVReading();
var
    BuffAnsi : AnsiString;              //obt@
    BuffSize : Integer;             //obt@TCY
    BuffName : WideString;          //obt@
    JVReadingCount : Integer;       //Ǎ݃t@C
    ReturnCode  : Integer;              //JVLinkԒl
    BuffVar : OleVariant;
    P: Pointer;
begin
    //l
    JVReadingCount:=0;
    Caption := 'f[^ǍݒDDD(0/' + IntToStr(ReadCount) + ')';
    ProgressBar2.Position := 0;
    ProgressBar2.Max:=ReadCount;
    //obt@̈m
    BuffSize := 110000;

    while True do begin


        //obNOEhł̏
        Application.ProcessMessages;
    	BuffVar := VarArrayCreate([0, 0],varByte);

        //LZꂽ珈𔲂
        if DialogCancel=true then exit;

            //***************
            //JVLinkǍݏ
            //***************
//            ReturnCode :=  frmMain.JVLink1.JVRead(Buff, BuffSize, BuffName);
            ReturnCode :=  frmMain.JVLink1.JVGets(BuffVar, BuffSize, BuffName);
            //G[
            if ReturnCode > 0 then begin          //I

                // JVReadɏIꍇ̓obt@[̓eʂɕ\܂B
                // TvvOł邽ߒPɑSẴf[^\Ă܂Aʕ\
                // ͎Ԃ̂鏈ł邽ߓǂݍݏŜ̎sԂxȂĂ܂B
                // Kvɉĉ̂PsRgAEg邩̏ɒuĂB

                SetLength(BuffAnsi, ReturnCode);
                P := VarArrayLock(BuffVar);
                try
                   Move(P^, BuffAnsi[1], ReturnCode);
                finally
                   VarArrayUnlock(BuffVar);
                   VarClear(BuffVar);
               end;
                frmMain.PrintOut(BuffAnsi);

                end
            else if ReturnCode = -1 then begin    //t@C̐؂
                //t@C\
                frmMain.PrintFilelist(BuffName + #13#10 );
                frmMain.PrintOut('Read File:'+ IntToStr(ReturnCode) + #13#10 );
                //vOXo[\
                JVReadingCount:=JVReadingCount+1; //JEgAbv
                ProgressBar2.Position:=JVReadingCount;
                Caption := 'f[^ǍݒDDD(' + IntToStr(JVReadingCount) + '/' + IntToStr(ReadCount) + ')';
                end

            else if ReturnCode = 0 then begin     //SR[hǍݏI(EOF)
                frmMain.PrintOut('JVRead EndOfFile :' + IntToStr(ReturnCode) + #13#10 );
                Caption := 'f[^Ǎ݊(' + IntToStr(JVReadingCount) + '/' + IntToStr(ReadCount) + ')';
                //Repeat𔲂
                Break;
                end
            else if ReturnCode < -1 then begin    //Ǎ݃G[
                frmMain.PrintOut('JVReadG[:' + IntToStr(ReturnCode) + #13#10 );
                //Repeat𔲂
                Break;
                end;

    end;

    Exit;

end;

//------------------------------------------------------------------------------
//      LZ{^NbN̏
//------------------------------------------------------------------------------
procedure TfrmJVLinkDialog.ButtonCancelClick(Sender: TObject);
begin
    //^C}[I
    TimerJVStatus.Enabled := False;

    //***************
    //JVLink~
    //***************
     frmMain.JVLink1.JVCancel();

    //LZtOĂ
    DialogCancel:=true;

    //bZ[W\
    frmMain.PrintOut('JVCancel:LZ܂' + #13#10 );
    Caption := 'JVCancel:LZ܂';

    Exit;
end;

//------------------------------------------------------------------------------
//      I
//------------------------------------------------------------------------------
procedure TfrmJVLinkDialog.JVClosing();
var
    ReturnCode  : Integer;              //JVLinkԒl
begin

    //***************
    //JVLinkI
    //***************
    ReturnCode :=  frmMain.JVLink1.JVClose;

    Cursor:=crDefault;

    //G[
    If ReturnCode <> 0 Then     //G[
        frmMain.PrintOut('JVCloseG[:' + IntToStr(ReturnCode) + #13#10 )
    Else                        //
        frmMain.PrintOut('JVCloseI:' + IntToStr(ReturnCode) + #13#10 );

    Exit;
end;

end.
